const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'tournament_prize',
  table_schema: {
    tournament_id: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    title: {
      type: Sequelize.TEXT,
      allowNull: false
    },
    value: {
      type: Sequelize.INTEGER,
      allowNull: false
    },
    text: {
      type: Sequelize.TEXT,
      allowNull: true
    },
    order: {
      type: Sequelize.INTEGER,
      allowNull: false
    }
  },
  table_indexes: [
    {
      name: 'tournament_prize_tournament_id',
      fields: ['tournament_id']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth,
  //cache seconds below
  cacheTime: 60
};
