const Sequelize = require('sequelize');
const AdminAuth = require('../classes/admin_wrapper');

module.exports = {

  table_name: 'tournament_team',
  table_schema: {
    tournament_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    team_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    rank: {
      type: Sequelize.INTEGER,
      defaultValue: 0
    },
    seed: {
      type: Sequelize.INTEGER,
      allowNull: true 
    },
    checkin_dttm: {
      type: Sequelize.DATE,
      defaultValue: null,
    },
    registered_dttm: {
      type: Sequelize.DATE,
      defaultValue: null,
    },
  },
  relation: {
    team : [
      {
        foreignKey: 'team_id',
        otherKey: 'team_id',
        constraints: false
      }
    ],
  },
  include: [
    {
      tableName: 'team',
      attributes: ["team_id", "name"],
    }
  ],
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
