const AdminAuth = require('../classes/admin_wrapper');
const Sequelize = require('sequelize');

const DAY_IN_MS = 24 * 3600 * 1000;

module.exports = {
  table_name: 'user',
  table_schema: {
    email: {
      type: Sequelize.STRING,
      allowNull: true,
      unique: true,
      roles: false
    },
    mixer_username: {
      type: Sequelize.STRING,
      allowNull: true
    },
    phone_number: {
      type: Sequelize.STRING,
      allowNull: true,
      unique: true,
      roles: false
    },
    bio: {
      type: Sequelize.TEXT,
      allowNull: true,
    },
    active_match_id: {
      type: Sequelize.STRING,
      allowNull: true,
    },
    username: {
      type: Sequelize.STRING,
      allowNull: false,
      unique: true
    },
    password: {
      type: Sequelize.STRING,
      roles: false
    },
    image_url: {
      type: Sequelize.STRING,
      defaultValue: "https://s3-us-west-2.amazonaws.com/bebo-images-usw2/misc/default_user.png",
    },
    has_pc: {
      type: Sequelize.BOOLEAN,
      defaultValue: false
    },
    has_ps4: {
      type: Sequelize.BOOLEAN,
      defaultValue: false
    },
    has_xbox: {
      type: Sequelize.BOOLEAN,
      defaultValue: false
    },
    current_platform: {
      type: Sequelize.STRING,
      allowNull: true
    },
    campaign: {
      type: Sequelize.JSONB(),
      defaultValue: {"name": "organic"}
    }
  },
  table_indexes: [
    {
      name: 'user_username',
      fields: ['username']
    },
    {
      name: 'user_email',
      fields: ['email']
    }
  ],
  relation: {
    league: [
      {
        through: {
          table_name: 'user_league',
          unique: false
        },
        foreignKey: 'user_id',
        otherKey: 'league_id',
        constraints: false
      }
    ],
    team: [
      {
        through: {
          table_name: 'user_team',
          unique: false
        },
        foreignKey: 'user_id',
        otherKey: 'team_id',
        constraints: false
      }
    ],
    match: [
      {
        table_name: 'match',
        foreignKey: 'active_match_id',
        constraints: false
      }
    ],
    set: [
      {
        through: {
          // model implicit
          table_name: 'set_user',
          unique: false
        },
        foreignKey: 'user_id',
        constraints: false
      }
    ]
  },
  include: [
    {
      tableName: 'league',
      through: { attributes: [] },
    }
  ],
  getterMethods: {
    days: function() {
      return Math.floor((Date.now() - this.getDataValue('created_dttm')) / DAY_IN_MS);
    },
  },
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
