const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'user_kill',
  table_schema: {
    no_value: {
      type: Sequelize.NUMERIC,
      defaultValue: 0.0
    },
    yes_value: {
      type: Sequelize.NUMERIC,
      defaultValue: 0.0
    },
    image_url: {
      type: Sequelize.STRING,
      defaultValue: ""
    },
    verified: {
      type: Sequelize.BOOLEAN,
      defaultValue: false
    },
    game: {
      type: Sequelize.STRING,
      defaultValue: ""
    }
  },
  table_indexes: [
    {
      name: 'user_kill_no_value',
      fields: ['no_value']
    },
    {
      name: 'user_kill_yes_value',
      fields: ['yes_value']
    },
    {
      name: 'user_kill_verified',
      fields: ['verified']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
