const AdminAuth = require('../classes/admin_wrapper');
const Sequelize = require('sequelize');

module.exports = {
  table_name: 'user_league',
  table_schema: {
    user_id: {
      type: Sequelize.STRING,
      allowNull: false
    },
    league_id: {
      type: Sequelize.STRING,
      allowNull: false
    }
  },
  table_indexes: [
    {
      unique: true,
      fields: ['user_id', 'league_id']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
