const AdminAuth = require('../classes/admin_wrapper');

const Sequelize = require('sequelize');

module.exports = {
  table_name: 'user_victory',
  table_schema: {
    value: {
      type: Sequelize.NUMERIC,
      defaultValue: 0.0
    },
    image_url: {
      type: Sequelize.STRING,
      allowNull: false
    },
    verified: {
      type: Sequelize.BOOLEAN,
      defaultValue: false
    }
  },
  table_indexes: [
    {
      name: 'user_victory_value',
      fields: ['value']
    },
    {
      name: 'user_victory_verified',
      fields: ['verified']
    }
  ],
  //custom fields below,
  postAuth: AdminAuth,
  deleteAuth: AdminAuth,
  putAuth: AdminAuth
};
