const chai = require('chai');
const chaiHttp = require('chai-http');
const should = chai.should();
const faker = require('faker');
const logger = require('bebo-node-commons').Logger;

chai.use(chaiHttp);

describe('/user test suite', () => {
  let server;
  let user;
  let username = faker.internet.userName();
  let email = faker.internet.email();
  let password = faker.internet.password();
  let access_token;

  before(async function() {
    logger.info("config init");
    const config = require("../api/config");
    await config.init({name: "pharah"});
    const PharahApp = require('../pharah_app.js');
    const pharahPromise = PharahApp();
    server = await pharahPromise;
  });

  it('/user/me w/o auth', done => {
    chai
      .request(server)
      .get('/user/me')
      .end((err, res) => {
        // there should be no errors
        should.not.exist(err);
        // there should be a 200 status code
        res.status.should.equal(401);
        done();
      });
  });

  it('/user/signup', done => {
    chai
      .request(server)
      .post('/user/signup')
      .send({ username, password, email })
      .end((err, res) => {
        should.not.exist(err);
        res.status.should.equal(200);
        res.type.should.equal('application/json');
        res.body.result.length.should.eql(1);
        res.body.result[0].should.include.keys('user_id', 'username', 'access_token');
        done();
      });
  });

  it('/user/signup - username taken', done => {
    chai
      .request(server)
      .post('/user/signup')
      .send({ username, password, email })
      .end((err, res) => {
        should.not.exist(err);
        res.status.should.equal(409);
        done();
      });
  });

  it('/user/login', done => {
    chai
      .request(server)
      .post('/user/login')
      .send({ username, password })
      .end((err, res) => {
        should.not.exist(err);
        res.status.should.equal(200);
        res.type.should.equal('application/json');
        res.body.result.length.should.eql(1);
        res.body.result[0].should.include.keys('user_id', 'username', 'access_token');
        access_token = res.body.result[0].access_token;
        done();
      });
  });

  it('/user/me with auth', done => {
    chai
      .request(server)
      .get('/user/me')
      .set('x-access-token', access_token)
      .end((err, res) => {
        should.not.exist(err);
        res.status.should.equal(200);
        res.type.should.equal('application/json');
        res.body.result.length.should.eql(1);
        res.body.result[0].should.include.keys('user_id', 'username');
        done();
      });
  });
});
