
const config = require('./api/config');
const logger = require('./api/logger');
const Broadcast = require('./api/broadcast');
const dispatcher = require('./api/dispatcher');


async function main() {

  await config.init({name: "pharah"});
  config.name = "tinder";
  config.CODE_NAME = "tinder"

  await logger.init(config);
  await Broadcast.init(config);
  await dispatcher.init(config);

  const mm = require('micromatch');
  const Sentry = require('@sentry/node');

  logger.info('sentry');

  const MatchWorker = require('./tinder/match_worker.js');
  const TournamentWorkerBracket = require('./tinder/tournament_worker_bracket.js');
  const TournamentWorkerStorm = require('./tinder/tournament_worker_storm.js');
  const SQS = require('./tinder/sqs.js');
  const IntervalWorker = require('./tinder/interval_worker.js');

  process.on('unhandledRejection', (reason, p) => {
    // FIXME we need to also handle rejectionHandled as some are handled later...
    logger.warning('Tinder Unhandled Promise.reject at: Promise', p, 'reason:', reason);
  });

  if (config.isLocal()) {
    Sentry.init({
      dsn: '**REMOVED**',
      environment: config.env,
      release: process.env.BEBO_VERSION
    });
  }

  const sqs_workers = {
    'MatchWorker': MatchWorker,
    'TournamentWorkerStorm': TournamentWorkerStorm,
  };

  logger.info("creating tinder SQS");
  const tinderSQS = SQS(logger);

  async function onMessage(message) {
    const { url } = message;
    for (const worker_id in sqs_workers) {
      const worker = sqs_workers[worker_id];
      const subscriptions = worker.subscribeUrls;
      const isMatch = mm.some(url, subscriptions);
      if (isMatch) {
        await worker.onMessage(message);
      }
    }
  }

  tinderSQS.registerHandler(onMessage);

  IntervalWorker.registerWorker(TournamentWorkerBracket);
  IntervalWorker.registerWorker(TournamentWorkerStorm);
  IntervalWorker.registerWorker(MatchWorker);
 
  console.log("starting sqs");
  tinderSQS.start();
  console.log("ended sqs");
};
main();

