const os = require('os');
const _ = require('lodash');
const Promise = require('bluebird');
const uuid = require('uuid');
const { User, Dispatcher } = require('bebo-node-commons');
const makeESFriendly = Dispatcher.Utils.makeESFriendly;
const makeUserESFriendly = Dispatcher.Utils.makeUserESFriendly;
const logger = require('../api/logger');

const hostname = os.hostname();

const dispatcherQueue = Dispatcher.getInstance({
  queueName: 'tinder-events_es',
  pickup_rate_ms: 5000
});

var clientEventQueue = Dispatcher.getInstance({
  pickup_rate_ms: 30 * 1000,
  queueName: 'client-events_es'
});

module.exports.writeEvent = function(data) {
  if (!data.node) data.node = hostname;

  let promise_map = {};
  if (data.user_id && (!data.user || data.user.user_id !== data.user_id)) {
    promise_map.user = User.get(data.user_id);
  }
  return Promise.props(promise_map)
    .then(({ user }) => {
      data = Dispatcher.Utils.makeESFriendly(data);
      if (user) {
        data.user = user;
      }
      try {
        return dispatcherQueue.writeEvent(data);
      } catch (err) {
        logger.error('failed to write dispatcher on ws.error', err);
      }
    })
    .catch(err => {
      logger.error("failed to writeEvent", err);
    })
};

// TODO move this to common - this is copied from pharah/classes/analytics...
function mkClientEvent(category, action, label, value, options) {

  if (!options) {
    options = {};
  }

  if (label != null && typeof label !== 'string') {
    label = label.toString();
  }

  if (label == null) {
    label = undefined;
  }

  var now = new Date();

  var event = {
    _id: options._id || uuid.v4(),
    category_tx: category,
    action_tx: action,
    label_tx: label,
    event_at: now.getTime(),
    event_dttm: now.toISOString(),
    node_tx: hostname
  };


  if (label) {
    event.routing_key = category + '.' + action + '.' + label;
  } else {
    event.routing_key = category + '.' + action;
  }

  if (typeof value === 'number') {
    event.value_nr = value;
  }
  if (options) {
    _.assign(event, options);
    delete event.user;
    delete event.data;
    delete event.user_id;
  }
  if (options.user) {
    event.user = makeUserESFriendly(options.user);
    event.user_id = event.user.user_id;
  }

  if (options.data) {
    event.data = makeESFriendly(options.data, 1);
  }
  return event;
}

module.exports.track = async function track(category, action, label, value, options) {
  if (!category || !action) {
    return false;
  }
  if (options.user_id) {
    options.user = await User.get(options.user_id);
  }
  var event = mkClientEvent(category, action, label, value, options);

  // logger.debug("EVENT", JSON.stringify(event, null, 2));
  return clientEventQueue.writeEvent(event);
};


