const logger = require('../api/logger');

class IntervalWorker {
  constructor() {
    this.workers = {};
    this.intervals = {};
  }

  startInterval(worker) {
    const id = worker.id;
    const interval = worker.interval;
    const onInterval = worker.onInterval;
    logger.info(`startInterval id: ${id} interval: ${interval}`);

    if(!(id in this.intervals)) {
      logger.info(`startInterval creating new setInterval for ${id}`);
      onInterval();
      this.intervals[id] = setInterval(onInterval, interval);
    }
  }

  stopInterval(name) {
    logger.info(`stopInterval ${name}`);
    if(!(name in this.intervals)){
      logger.warn(`stopInterval ${name}: doesn't exist in this.intervals, doing nothing`);
      return;
    }

    clearInterval(this.intervals[name]);
    delete this.intervals[name];
    logger.info(`stopInterval ${name}: clearInterval and delete`);
  }

  registerWorker(worker){
    const id = worker.constructor.name;
    logger.info("IntervalWorker registerWorker id: ", id);
    worker.id = id;
    if(!(id in this.workers)){
      this.workers[id] = worker;
    }

    this.startInterval(worker);
  }

  unRegisterWorker(worker) {
    const id = worker.constructor.name;
    logger.info("IntervalWorker unRegisterWorker id: ", id);

    this.stopInterval(id);
  }
}

module.exports = new IntervalWorker();
