const rp = require('request-promise');
const config = require('../config');
const logger = require('../api/logger');

const PharahClient = {
  base: (api, options) => {
    const headers = {
      'X-Api-Key': config.SERVICE_API_KEY
    };
    if (options.body && options.body.user_id) {
      headers['X-User-Id'] = options.body.user_id;
    }
    if (options.qs && options.qs.user_id) {
      headers['X-User-Id'] = options.qs.user_id;
    }
    return rp(
      Object.assign(
        {
          url: `${config.aws_api_url}${api}`,
          headers
        },
        options
      )
    ).then(res => {
      if (logger.isDebug()) {
        const code = res.code || 0;
        logger.debug(options.method, api, JSON.stringify(options.body) || options.qs, code);
      }
      return res;
    }).catch(e => {
      logger.error(options.method, api, options.body || options.qs, e.message);
      throw e;
    });
  },
  get: (api, qs) => {
    return PharahClient.base(api, {
      method: 'GET',
      qs,
      json: true
    });
  },
  post: (api, data) => {
    return PharahClient.base(api, {
      method: 'POST',
      body: data,
      json: true
    });
  },
  put: (api, data) => {
    return PharahClient.base(api, {
      method: 'PUT',
      body: data,
      json: true
    });
  },
  delete: (api, data) => {
    return PharahClient.base(api, {
      method: 'DELETE',
      qs: data,
      json: true
    });
  }
};

module.exports = PharahClient;
