# Player Release Notes

## Future Release

### Enhancements

### Fixed Issues


## Version 2.14.0 (2019-08-08)

### Enhancements
* (Web) Add TTV (time to video) metrics to `video-play` event. (#4245)
* (Android) Eliminate lag created when swapping surfaces. (#4283)
* (PS4) (XB1) Add `requestServerAd()` API to inject ads. (#4323)

### Fixed Issues
* (Web) Fix DRM playback. (#4304)
* (Web) Fix optimal playback resolution being too low. (#4298)
* (Web) Fix Video.js player error when initialized with `muted: true`. (#4289)
* (Web) Fix Video.js player `dispose()` call throwing errors. (#4326)
* (Android) Fix `java.lang.IllegalStateException` thrown while setting surface. (#4309)
* (iOS) Fix playback rate value not zero when `pause()` is called. (#4234)
* (PS4) Fix crash by reordering TrackSink destruction. (#4294)
* (tvOS) Fix audio and video being out of sync and stuttering. (#4292)
* (Chromecast) Fix start VOD start position while beginning remote playback. (#4297)


## Version 2.13.0 (2019-07-15)

### Enhancements
* (Web) Disable manual quality selection for non-MSE playback. (#4251)
* (Android) Update Android API for consistency. (#4268)

### Fixed Issues
* (Web) Fix some occurrences of repeated audio/video upon foregrounding. (#4241)
* (Web) Fix uncaught `QuotaExceededError` thrown on decode error. (#4254)
* (iOS) Fix bug causing certain videos to crash when querying for `naturalSize`. (#4260)
* (iOS) Fix bugs with seek slider. (#4158)
* (Android TV) (Fire TV) (PS4) (XB1) (tvOS) Fix bug causing clips playback to fail on WiFi. (#4264)
* (PS4) (XB1) Fix issue causing clips to freeze mid-playback. (#4231)
* (XB1) Fix bug causing video to freeze on 160p resolution. (#4269)
* (tvOS) Fix issue causing app to sometimes crash after playback .(#4270)
* (tvOS) Fix bug causing video to take a long time to resume when foregrounding app. (#4249)


## Version 2.12.0 (2019-06-28)

### Enhancements
* (Core) Add `onSinkDurationChanged()` callback to passthrough sink. (#4141)
* (Core) Remove need to append `prefetch_segments` query param for low latency streams. (#4217)
* (Core) Rename `preferred_codecs` to `supported_codecs`. (#4147)
* (Web) Add `setAutoplay()` API. (#4175)
* (Web) Add `SESSION_STARTED` event to play(). (#4198)
* (Web) Add RequestMode for CORS to enable `no-cors` for analytics requests. (#4122)
* (Web) Set default playback rate to 1. (#4154)
* (Chromecast) Add MediaSink for Chromecast. (#4165)

### Fixed Issues
* (Core) Fix incorrect value for `average_bitrate` analytics property. (#4161)
* (Core) Fix potential race condition with AsyncPlayer GetSessionData. (#4202)
* (Web) Fix `PLAYBACK_RATE_CHANGED` incorrectly firing multiple times. (#4227)
* (Web) Fix `Invalid Argument` error on Edge. (#4166)
* (Web) Fix issues with calling `setMuted()` and `setVolume()` before `load()`. (#4165)
* (Web) Fix issue with buffering spinner not going away after seeking and changing qualities. (#4163)
* (Web) Fix issue where Video.js player does not play after waking phone from sleep mode. (#4135)
* (Web) Fix `Failed to execute 'addSourceBuffer' on 'MediaSource': The type provided ('video/mp4;defined) is unsupported.` error. (#4235)


## Version 2.11.0 (2019-06-28)

### Enhancements
* (Core) Add support for Timed Metadata.
* (Web) Add TTV (time to video) metrics to video-play event.

### Fixed Issues
* (Core) Fix `average_bitrate` property in tracking events not having the correct value.
* (Core) Fix loading spinner appearing on paused streams.
* (Web) Fix incorrect TypeScript declaration path.
* (Web) Fix streams not playing on iOS mobile web after the device awakens from sleep.
* (Web) Fix tracking events causing CORS errors.
* (Web) Fix JavaScript console errors during playback in Microsoft Edge.
