PlayerCore
===========================

PlayerCore is a cross platform video player that can play twitch's HLS streams and other types of media.
PlayerCore is designed with a flexible architecture that can support different types of input and
output media and run on almost any platform. See an overview of how it works [here](https://docs.google.com/presentation/d/1AWiZo8E1f8fmQc3C4DSqex0_60FFehzaBJ0Oct7_yOQ/edit?usp=sharing).

## APIs

| Platform | API | Language       |
|----------|-----|----------------|
| C++      | [Player.hpp](include/playercore/Player.hpp) | C++ |
| Web      | [mediaplayer.ts](platforms/web/js/mediaplayer.ts) | Javascript |
| Android  | [MediaPlayer.java](platforms/android/library/src/main/java/tv/twitch/android/player/MediaPlayer.java) | Java |
| iOS      | [TTVPlayer.h](platforms/ios/TTVPlayer.h) | Objective-C |

## Supported Platforms

### Browsers

| Browser | Supported platforms                      | Minimum supported version |
|---------|------------------------------------------|---------------------------|
| Chrome  | Windows, Mac, Android, Linux, Chromecast | 63.0     |
| Firefox | Windows, Mac, Android, Linux             | 57.0     |
| Edge    | Windows 8.1+                             | 44.0     |
| IE11    | Windows 8.1+                             | 11.0.105 |
| Safari  | Mac, iOS (passthrough only)              | 10.0     |

### Native

| Platform | Minimum supported version |
|----------|---------------------------|
| Android  | 4.1 (Jellybean)           |
| iOS      | iOS 9.0 (In development)  |
| UWP      | Build 17134 (version 1803)|
| PS4      | SDK 4.5                   |
| FireOS   | 5.0                       |

### Formats

The following containers and formats are currently supported:

| Container | AVC | HEVC | VP9 | AAC | AC3 | PCM |
|-----------|-----|------|-----|-----|-----|-----|
| MPEG2-TS  |  Y  |   N  |  N  |  Y  |  N  |  N  |
| CMAF/MP4  |  Y  |   N  |  Y  |  Y  |  N  |  N  |


### Architecture overview

![alt PlayerCore.svg](https://git-aws.internal.justin.tv/purushen/player-core-arch/blob/master/PlayerCore.svg)
[Link](https://git-aws.internal.justin.tv/raw/purushen/player-core-arch/master/PlayerCore.svg?token=AAAB19Vu4u-l2wpcSRlgOBmAWjRge3REks5dHS9swA%3D%3D&sanitize=true)

## Code style

* Follow the [WebKit coding style guidelines](https://webkit.org/code-style-guidelines/)
* Use `git clang-format` to format C++ code before committing

## Build instructions

* [Javascript](platforms/web/README.md)
* [Android](platforms/android/README.md)
* [iOS](platforms/ios/README.md)
* [PS4](platforms/ps4/README.md)
* [UWP](platforms/uwp/README.md)
* [Windows](platforms/windows/README.md)
