#
# Add conditional options to a CMake configuration
#
#
# PARAMETERS
#
# Function(s):
#
#   add_conditional_option(<option> CONDITION <condition> DESCRIPTION <description>) - Adds a CMake option
#       that uses a condition to set the default value and enforce the value of the option
#

include(VerboseMessage)

macro(evaluate_condition variable)
  set(condition ${ARGN})
  verbose_message("Evaluating condition: ${condition}")
  separate_arguments(condition)
   if((${condition}))
     set(${variable} ON)
   else()
     set(${variable} OFF)
   endif()
endmacro()

function(add_conditional_option option)
  verbose_message("Adding conditional option: ${option}")

  set(options "")
  set(oneValueArgs CONDITION DESCRIPTION)
  set(multiValueArgs "")
  cmake_parse_arguments(add_conditional_option "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN})

  if(NOT add_conditional_option_CONDITION)
    message(SEND_ERROR "Missing required argument: CONDITION")
  endif()

  if(DEFINED ${option})
    set(default ${${option}})
  else()
    evaluate_condition(default ${add_conditional_option_CONDITION})
  endif()

  verbose_message("Default: ${default}")
  option(${option} "${add_conditional_option_DESCRIPTION}" ${default})

  if(${option})
    evaluate_condition(passed ${add_conditional_option_CONDITION})
    if(NOT (${passed}))
      message(WARNING "${option} option not supported for condition: ${add_conditional_option_CONDITION}")
      set(${option} OFF CACHE BOOL ${add_conditional_option_DESCRIPTION} FORCE)
    endif()
  endif()
endfunction()
