#
# CMake module for using address sanitizer for fast memory error detection
#
#
# OUTPUTS:
#
# Variabless:
#
#   ADDRESS_SANITIZER_COMPILER_OPTIONS - Address Sanitizer compiler options
#   ADDRESS_SANITIZER_LINKER_OPTIONS - Address Sanitizer linker options
#
# Resourcs:
#
#   https://clang.llvm.org/docs/AddressSanitizer.html
#   https://ps4.scedev.net/resources/documents/SDK/3.500/Sanitizers-Overview/0003.html
#

set(ADDRESS_SANITIZER_COMPILER_OPTIONS
  -fsanitize=address
  -g

  # For nicer stack traces
  -fno-optimize-sibling-calls  # disable inlining
)

if(NOT CMAKE_SYSTEM_NAME STREQUAL "PS4")
  # disable tail call elimination
  list(APPEND ADDRESS_SANITIZER_COMPILER_OPTIONS -fno-omit-frame-pointer)
endif()

if(CMAKE_BUILD_TYPE STREQUAL Debug)
  # for reasonable performance and nicer stack traces
  list(APPEND ADDRESS_SANITIZER_COMPILER_OPTIONS -O1)
endif()

add_compile_options(${ADDRESS_SANITIZER_COMPILER_OPTIONS})

set(ADDRESS_SANITIZER_LINKER_OPTIONS -fsanitize=address)
if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Linux")
  set(ADDRESS_SANITIZER_LINKER_OPTIONS "${ADDRESS_SANITIZER_LINKER_OPTIONS} -lgcov")
elseif(CMAKE_SYSTEM_NAME STREQUAL "PS4")
  set(ADDRESS_SANITIZER_LINKER_OPTIONS "${ADDRESS_SANITIZER_LINKER_OPTIONS} -lSceDbgAddressSanitizer_stub_weak")
endif()

if(CMAKE_EXE_LINKER_FLAGS STREQUAL "")
  set(CMAKE_EXE_LINKER_FLAGS ${ADDRESS_SANITIZER_LINKER_OPTIONS} CACHE STRING "" FORCE)
else()
  set(CMAKE_EXE_LINKER_FLAGS "${CMAKE_EXE_LINKER_FLAGS} ${ADDRESS_SANITIZER_LINKER_OPTIONS}" CACHE STRING "" FORCE)
endif()
