#
# CMake module to help add code coverage flags and targets
#
#
# PARAMETERS
#
# Required Programs - If not specified, CMake will do its best to find the
# program, but it can also be specified by:
#
#   CODE_COVERAGE_GCOVR - Path to gcovr (installation: http://gcovr.com/guide.html#installation)
#
# Optional parameters:
#
#   CODE_COVERAGE_FORMAT - Format for the code coverage report (html/xml)
#
# OUTPUTS:
#
# Variables(s):
#
#   CODE_COVERAGE_COMPILER_FLAGS - Code coverage compiler flags
#   CODE_COVERAGE_LINKER_FLAGS - Code coverage linker flags
#
# Target(s):
#
#   coverage - Run this target to generate a coverage report
#

find_program(CODE_COVERAGE_GCOVR gcovr HINTS ~/.local/bin)
if(CODE_COVERAGE_GCOVR)
  set(CODE_COVERAGE_GCOVR ${CODE_COVERAGE_GCOVR} CACHE INTERNAL "Path to gcovr" FORCE)
else()
  message(CODE_COVERAGE_GCOVR "Cannot find the path to gcovr")
endif()

set(CODE_COVERAGE_COMPILER_FLAGS -g --coverage)
set(CODE_COVERAGE_LINKER_FLAGS --coverage)

set(CODE_COVERAGE_FORMAT "html" CACHE STRING "Format for the code coverage report (html/xml)")
set_property(CACHE CODE_COVERAGE_FORMAT PROPERTY STRINGS html xml)

set(CODE_COVERAGE_OUTPUT_FILE ${CMAKE_BINARY_DIR}/coverage.${CODE_COVERAGE_FORMAT})

set(CODE_COVERAGE_GCOV_ARGS
  --branches
  --object-directory=${CMAKE_BINARY_DIR}
  --root=${CMAKE_SOURCE_DIR}
  --output=${CODE_COVERAGE_OUTPUT_FILE}
  --delete
  --${CODE_COVERAGE_FORMAT}
)

if(CMAKE_SYSTEM_NAME MATCHES "Linux")
  list(APPEND CODE_COVERAGE_GCOV_ARGS --gcov-executable='llvm-cov gcov')
endif()

add_custom_target(coverage
  COMMAND ${CODE_COVERAGE_GCOVR} ${CODE_COVERAGE_GCOV_ARGS}
  COMMAND ${CMAKE_COMMAND} -E echo "Coverage report generated: ${CODE_COVERAGE_OUTPUT_FILE}"
  WORKING_DIRECTORY ${CMAKE_BINARY_DIR}
)
