#
# CMake module to help copy resource files
#
#
# Function(s):
#
#   copy_resources(
#     SOURCE <directory>
#     DESTINATION <directory>
#     FILES <file1> <file2> ...
#   )
#
#     This function copies resources FILES from the SOURCE directory to a
#     DESTINATION directory
#
#       SOURCE: The base directory where the resources are located
#       DESTINATION: The target destination of where to copy the resources
#       FILES: The file(s) to copy from the SOURCE directory (can be nested in subfolders)
#
#

macro(copy_resources)
  cmake_parse_arguments(
    PARSED_ARGS
    ""
    "DESTINATION;SOURCE"
    "FILES"
    ${ARGN}
  )

  set(required_arguments PARSED_ARGS_DESTINATION PARSED_ARGS_SOURCE PARSED_ARGS_FILES)
  foreach(argument ${required_arguments})
    if(NOT DEFINED ${argument})
      message(SEND_ERROR "Must provide argument: ${argument}")
    endif()
  endforeach()

  set(absolute_files "")
  foreach(file ${PARSED_ARGS_FILES})
    list(APPEND absolute_files ${PARSED_ARGS_SOURCE}/${file})
  endforeach()

  file(COPY ${absolute_files} DESTINATION ${PARSED_ARGS_DESTINATION})
endmacro()
