#
# Find module for CPPCheck
#
#
# PARAMETERS
#
# Required Programs - If not specified, CMake will do its best to find the
# program, but it can also be specified by:
#
#   CPPCHECK - Path to cppcheck
#
# OUTPUTS:
#
# Variables(s):
#
#   CPPCHECK_FILE_EXTS - Relevant file extensions
#
# Function(s):
#
#   enable_cppcheck(<dir1> <dir2> ...) - Adds a build target that
#       runs the cppcheck analysis for the given directories
#

include(FindPackageHandleStandardArgs)

find_program(CPPCHECK cppcheck)
find_package_handle_standard_args(CPPCheck DEFAULT_MSG CPPCHECK)

if(CPPCHECK)
  mark_as_advanced(CPPCHECK)
else()
  return()
endif()

set(CPPCHECK_FILE_EXTS c cc cpp h hpp)

function(get_glob_expressions globs directory)
  set(directory_globs "")
  foreach(file_ext ${CPPCHECK_FILE_EXTS})
    set(glob "${directory}/*.${file_ext}")
    if(directory_exts STREQUAL "")
      set(directory_globs ${glob})
    else()
      list(APPEND directory_globs ${glob})
    endif()
  endforeach()

  set(globs ${directory_globs} PARENT_SCOPE)
endfunction()

function(enable_cppcheck)
  set(all_files)
  foreach(directory ${ARGN})
    get_glob_expressions(globs ${directory})
    file(GLOB_RECURSE files ${globs})
    set(all_files ${all_files} ${files})
  endforeach()

  list(LENGTH all_files num_files)
  add_custom_target(
    check
    COMMAND ${CPPCHECK}
      --enable=warning
      --force
      --inconclusive
      --quiet
      --std=c++11
      ${all_files}
    COMMENT "Running CPPCheck for ${num_files} files"
  )
endfunction()
