#
# Prepends a path prefix to a list of files
#
# preprend_file_paths(<path_prefix> <filepaths_var>)
#
function(prepend_file_paths path_prefix filepaths_var)
    # Check the path_prefix for a trailing '/'
    string(REGEX MATCH ".*/$" trailing_slash ${path_prefix})
    if(NOT trailing_slash)
        string(CONCAT path_prefix ${path_prefix} "/")
    endif()

    set(prepended_filepaths)
    set(filepaths_tmp ${${filepaths_var}})
    foreach(filepath ${filepaths_tmp})
        string(CONCAT prepended_filepath ${path_prefix} ${filepath})
        list(APPEND prepended_filepaths ${prepended_filepath})
    endforeach()

    set(${filepaths_var} ${prepended_filepaths} PARENT_SCOPE)
endfunction()
