#
# Function(s):
#
#   set_folder_property(<target>) - Set a target's FOLDER property to the its
#       relative path to reflect directory structure
#

macro(set_folder_property target)
  file(RELATIVE_PATH relative_dir ${CMAKE_SOURCE_DIR} ${CMAKE_CURRENT_SOURCE_DIR})
  
  # If file path starts with "../" sequence, this will attempt to create an empty string filter in the Visual Studio Solution
  # file, so remove these prefixes from the filter property
  string(REGEX REPLACE "^(\\.\\./)+" "" relative_dir ${relative_dir})			
  set_target_properties(${target} PROPERTIES FOLDER ${relative_dir})
endmacro()
