#
# Module for configuring the project for the target platform
#
# VARIABLES
#
#   TARGET_PLATFORM - Name of the target platform
#

# TODO: Allow TARGET_PLATFORM to be passed as a configuration option

if(CMAKE_SYSTEM_NAME STREQUAL "Android")
  set(target_platform_name "Android")
elseif(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
  if(CMAKE_TOOLCHAIN_FILE MATCHES "iPhone")
    set(target_platform_name "iPhone")
  elseif(CMAKE_TOOLCHAIN_FILE MATCHES "AppleTV")
    set(target_platform_name "AppleTV")
  elseif(CMAKE_TOOLCHAIN_FILE MATCHES "OSX")
    set(target_platform_name "OSX")
  else()
    set(target_platform_name "Posix")
  endif()
elseif(CMAKE_SYSTEM_NAME STREQUAL "PS4" OR CMAKE_SYSTEM_NAME STREQUAL "ORBIS")
  set(target_platform_name "PS4")
elseif(CMAKE_SYSTEM_NAME STREQUAL "Emscripten")
  set(target_platform_name "Web")
elseif(CMAKE_SYSTEM_NAME STREQUAL "Windows")
  set(target_platform_name "Win64")
elseif(CMAKE_SYSTEM_NAME STREQUAL "WindowsStore")
  if(CMAKE_TOOLCHAIN_FILE MATCHES "XboxOne" OR CMAKE_TOOLCHAIN_FILE MATCHES "Toolchain-Uwp")
    set(target_platform_name "XboxOne")
  elseif(CMAKE_TOOLCHAIN_FILE MATCHES "WinStore")
    set(target_platform_name "WinStore")
  else()
    message(FATAL_ERROR "Unsupported CMAKE_TOOLCHAIN_FILE=${CMAKE_TOOLCHAIN_FILE}")
  endif()
elseif(CMAKE_SYSTEM_NAME STREQUAL "Linux")
  set(target_platform_name "Posix")
else()
  message(FATAL_ERROR "Unknown target platform CMAKE_SYSTEM_NAME=${CMAKE_SYSTEM_NAME}")
endif()

set(TARGET_PLATFORM ${target_platform_name} CACHE STRING "External Dependency Projects")
