include(ExternalDependency)

# NOTE: Because this is an internal Twitch URL, the git connection protocol
#   (i.e. "https://" vs "git@") will be chosen based on the host OS
if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Windows")
  set(JSON11_GIT_URL "https://git-aws.internal.justin.tv/player-core/json11.git")
else()
  set(JSON11_GIT_URL "git@git-aws.internal.justin.tv:player-core/json11.git")
endif()
set(JSON11_GIT_TAG db00e9369a92aa74bf630a2ffb092a4b0b132c01)

if(BUILD_DEPENDENCY_SUBMODULES)
  set(JSON11_location_key SOURCE_DIR)
  set(JSON11_location_value ${CMAKE_CURRENT_SOURCE_DIR}/vendor/json11)
else()
  set(JSON11_location_key GIT_REPOSITORY)
  set(JSON11_location_value ${JSON11_GIT_URL})
endif()

add_external_dependency(JSON11
  ${JSON11_location_key} ${JSON11_location_value}
  GIT_TAG ${JSON11_GIT_TAG}
  CMAKE_ARGS
    ${EXTERNAL_DEPENDENCY_COMMON_CMAKE_ARGS}
  CMAKE_CACHE_ARGS
    -DENV{DEVELOPMENT_TEAM_ID}:STRING=$ENV{DEVELOPMENT_TEAM_ID}
  BUILD_BYPRODUCTS
    ${EXTERNAL_DEPENDENCY_DIR}/lib/${CMAKE_LIBRARY_ARCHITECTURE}/${CMAKE_STATIC_LIBRARY_PREFIX}json11${CMAKE_STATIC_LIBRARY_SUFFIX}
)

include_directories(SYSTEM ${EXTERNAL_DEPENDENCY_DIR}/include/${CMAKE_LIBRARY_ARCHITECTURE})

add_library(json11 STATIC IMPORTED)
set(installed_lib_dir ${EXTERNAL_DEPENDENCY_DIR}/lib/${CMAKE_LIBRARY_ARCHITECTURE})
set_target_properties(json11 PROPERTIES
  IMPORTED_LOCATION_DEBUG
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}json11${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELWITHDEBINFO
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}json11${CMAKE_RELWITHDEBINFO_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELEASE
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}json11${CMAKE_RELEASE_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
)

add_dependencies(json11 JSON11)
