include(ExternalDependency)

# NOTE: Because this is an internal Twitch URL, the git connection protocol
#   (i.e. "https://" vs "git@") will be chosen based on the host OS
if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Windows")
  set(LibCaption_GIT_URL "https://git-aws.internal.justin.tv/player-core/libcaption.git")
else()
  set(LibCaption_GIT_URL "git@git-aws.internal.justin.tv:player-core/libcaption.git")
endif()
set(LibCaption_GIT_TAG 46cccb2530f05683f2fb995d363068f8f86a95dc)

if(BUILD_DEPENDENCY_SUBMODULES)
  set(LibCaption_location_key SOURCE_DIR)
  set(LibCaption_location_value ${CMAKE_CURRENT_SOURCE_DIR}/vendor/libcaption)
else()
  set(LibCaption_location_key GIT_REPOSITORY)
  set(LibCaption_location_value ${LibCaption_GIT_URL})
endif()

add_external_dependency(LibCaption
  ${LibCaption_location_key} ${LibCaption_location_value}
  GIT_TAG ${LibCaption_GIT_TAG}
  CMAKE_ARGS
    ${EXTERNAL_DEPENDENCY_COMMON_CMAKE_ARGS}
    -DBUILD_EXAMPLES=OFF
    -DENABLE_RE2C=OFF
  CMAKE_CACHE_ARGS
    -DENV{DEVELOPMENT_TEAM_ID}:STRING=$ENV{DEVELOPMENT_TEAM_ID}
  BUILD_BYPRODUCTS
    ${EXTERNAL_DEPENDENCY_DIR}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}caption${CMAKE_STATIC_LIBRARY_SUFFIX}
)

include_directories(SYSTEM ${EXTERNAL_DEPENDENCY_DIR}/include)

add_library(caption STATIC IMPORTED)
set(installed_lib_dir ${EXTERNAL_DEPENDENCY_DIR}/lib)
set_target_properties(caption PROPERTIES
  IMPORTED_LOCATION_DEBUG
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}caption${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELWITHDEBINFO
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}caption${CMAKE_RELWITHDEBINFO_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELEASE
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}caption${CMAKE_RELEASE_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
)

add_dependencies(caption LibCaption)
