include(ExternalDependency)

if(CMAKE_HOST_SYSTEM_NAME STREQUAL "Windows")
  set(TinyAES_GIT_URL "https://git-aws.internal.justin.tv/player-core/tiny-AES-c.git")
else()
  set(TinyAES_GIT_URL "git@git-aws.internal.justin.tv:player-core/tiny-AES-c.git")
endif()
set(TinyAES_GIT_TAG 380b67e01feddd0d5347b3b8b3be44201e5bd90f)

if(BUILD_DEPENDENCY_SUBMODULES)
  set(TinyAES_location_key SOURCE_DIR)
  set(TinyAES_location_value ${CMAKE_CURRENT_SOURCE_DIR}/vendor/tiny-AES-c)
else()
  set(TinyAES_location_key GIT_REPOSITORY)
  set(TinyAES_location_value ${TinyAES_GIT_URL})
endif()

add_external_dependency(TinyAES
  ${TinyAES_location_key} ${TinyAES_location_value}
  GIT_TAG ${TinyAES_GIT_TAG}
  CMAKE_ARGS
    ${EXTERNAL_DEPENDENCY_COMMON_CMAKE_ARGS}
  BUILD_BYPRODUCTS
    ${EXTERNAL_DEPENDENCY_DIR}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}tinyaes{CMAKE_STATIC_LIBRARY_SUFFIX}
)

include_directories(SYSTEM ${EXTERNAL_DEPENDENCY_DIR})

add_library(tinyaes STATIC IMPORTED)

set(installed_lib_dir ${EXTERNAL_DEPENDENCY_DIR}/lib)
set_target_properties(tinyaes PROPERTIES
  IMPORTED_LOCATION_DEBUG
  ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}tiny-aes${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELWITHDEBINFO
  ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}tiny-aes${CMAKE_RELWITHDEBINFO_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELEASE
  ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}tiny-aes${CMAKE_RELEASE_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
)

add_dependencies(tinyaes tiny-aes)
