include(ExternalDependency)

if(CMAKE_SYSTEM_NAME STREQUAL "Darwin")

set(GCDWEBSERVER_GIT_URL "git@git-aws.internal.justin.tv:player-core/gcdwebserver.git")
set(GCDWEBSERVER_GIT_TAG d3d9395183e7636ae873ed8b82637f7822f87a51)

if(BUILD_DEPENDENCY_SUBMODULES)
  set(GCDWEBSERVER_location_key SOURCE_DIR)
  set(GCDWEBSERVER_location_value ${CMAKE_CURRENT_SOURCE_DIR}/vendor/gcdwebserver)
else()
  set(GCDWEBSERVER_location_key GIT_REPOSITORY)
  set(GCDWEBSERVER_location_value ${GCDWEBSERVER_GIT_URL})
endif()

add_external_dependency(GCDWEBSERVER
  ${GCDWEBSERVER_location_key} ${GCDWEBSERVER_location_value}
  GIT_TAG ${GCDWEBSERVER_GIT_TAG}
  CMAKE_ARGS
    ${EXTERNAL_DEPENDENCY_COMMON_CMAKE_ARGS}
  CMAKE_CACHE_ARGS
    -DENV{DEVELOPMENT_TEAM_ID}:STRING=$ENV{DEVELOPMENT_TEAM_ID}
  BUILD_BYPRODUCTS
    ${EXTERNAL_DEPENDENCY_DIR}/lib/${CMAKE_STATIC_LIBRARY_PREFIX}gcdwebserver${CMAKE_STATIC_LIBRARY_SUFFIX}
)

include_directories(SYSTEM ${EXTERNAL_DEPENDENCY_DIR}/include)

add_library(gcdwebserver STATIC IMPORTED)
set(installed_lib_dir ${EXTERNAL_DEPENDENCY_DIR}/lib)
set_target_properties(gcdwebserver PROPERTIES
  IMPORTED_LOCATION_DEBUG
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}gcdwebserver${CMAKE_DEBUG_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELWITHDEBINFO
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}gcdwebserver${CMAKE_RELWITHDEBINFO_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
  IMPORTED_LOCATION_RELEASE
    ${installed_lib_dir}/${CMAKE_STATIC_LIBRARY_PREFIX}gcdwebserver${CMAKE_RELEASE_POSTFIX}${CMAKE_STATIC_LIBRARY_SUFFIX}
)

add_dependencies(gcdwebserver GCDWEBSERVER)

endif()