set(CMAKE_SYSTEM_NAME Darwin)

find_program(XCRUN_EXE xcrun)
if(XCRUN_EXE)
  mark_as_advanced(XCRUN_EXE)
else()
  message(FATAL_ERROR "Cannot find program: xcrun")
endif()

execute_process(
  COMMAND ${XCRUN_EXE} -sdk appletvos --show-sdk-path
  OUTPUT_VARIABLE APPLETVOS_SDK_ROOT
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

# Workaround the broken compiler detection in cmake for
# the 'appletvos' sysroot. The development team string can
# be anything
set(CMAKE_MACOSX_BUNDLE "YES")
set(CMAKE_OSX_SYSROOT "appletvos" CACHE STRING "" FORCE)
set(CMAKE_XCODE_ATTRIBUTE_DEVELOPMENT_TEAM 94324UXTV2)
set(CMAKE_TRY_COMPILE_TARGET_TYPE STATIC_LIBRARY)

set(CMAKE_XCODE_EFFECTIVE_PLATFORMS "-appletvos")
set(CMAKE_XCODE_ATTRIBUTE_CLANG_CXX_LANGUAGE_STANDARD "c++11")
set(CMAKE_OSX_ARCHITECTURES "$(ARCHS_STANDARD)" CACHE STRING "" FORCE)

set(CMAKE_FIND_ROOT_PATH ${APPLETVOS_SDK_ROOT})
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE BOTH)

set(CMAKE_XCODE_ATTRIBUTE_CLANG_ENABLE_OBJC_ARC "YES")
set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_ALLOWED "YES")
set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_REQUIRED "NO")
set(CMAKE_OSX_DEPLOYMENT_TARGET "10.2")
set(CMAKE_XCODE_ATTRIBUTE_CLANG_CXX_LANGUAGE_STANDARD "c++11")
set(ENABLE_BITCODE TRUE CACHE BOOL "")
# disabled since signing cert may or may not be present during project generation
set(CMAKE_C_COMPILER_FORCED TRUE)
set(CMAKE_CXX_COMPILER_FORCED TRUE)
