set(CMAKE_SYSTEM_NAME Darwin)
add_definitions(-DIOS)

find_program(XCRUN_EXE xcrun)
if(XCRUN_EXE)
  mark_as_advanced(XCRUN_EXE)
else()
  message(FATAL_ERROR "Cannot find program: xcrun")
endif()

execute_process(
  COMMAND ${XCRUN_EXE} -sdk macosx --show-sdk-path
  OUTPUT_VARIABLE OSX_SDK_ROOT
  OUTPUT_STRIP_TRAILING_WHITESPACE
)

# Set the CMAKE_OSX_SYSROOT to the latest IPHONEOS_SDK_ROOT found
set(CMAKE_OSX_SYSROOT "macosx" CACHE STRING "" FORCE)
set(CMAKE_OSX_ARCHITECTURES "$(ARCHS_STANDARD)" CACHE STRING "" FORCE)
set(CMAKE_FIND_ROOT_PATH ${OSX_SDK_ROOT})
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE BOTH)

# Xcode requires the bundle/code signing to be set in the toolchain file (https://public.kitware.com/Bug/view.php?id=15329)
set(CMAKE_MACOSX_BUNDLE YES)
set(CMAKE_XCODE_ATTRIBUTE_CLANG_ENABLE_OBJC_ARC "YES")
set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_ALLOWED "YES")
set(CMAKE_XCODE_ATTRIBUTE_CODE_SIGNING_REQUIRED "NO")
set(CMAKE_XCODE_EFFECTIVE_PLATFORMS "-macosx")
set(ENABLE_BITCODE TRUE CACHE BOOL "")

set(MACOSX_BUNDLE_GUI_IDENTIFIER tv.twitch)
