set(CMAKE_SYSTEM_NAME PS4)
set(CMAKE_SYSTEM_VERSION 1)
set(CMAKE_CROSSCOMPILING 1)

set(PS4_SDK_DIR $ENV{SCE_ORBIS_SDK_DIR})
if (NOT ${PS4_SDK_DIR} STREQUAL "")
    string(REPLACE "\"" "" PS4_SDK_DIR ${PS4_SDK_DIR})
    get_filename_component(PS4_SDK_DIR ${PS4_SDK_DIR} ABSOLUTE )
  if (NOT EXISTS ${PS4_SDK_DIR})
    message( FATAL_ERROR "The PS4 SDK could not be found at ${PS4_SDK_DIR}")
  else()
    message(STATUS "Found PS4 SDK: ${PS4_SDK_DIR}")
  endif()
else()
  message( FATAL_ERROR "Missing SCE_ORBIS_SDK_DIR environment variable. Did you install the PS4 SDK ?")
endif()

set(PS4_SDK_INCLUDE_DIR ${PS4_SDK_DIR}/target/include)

#PS4 Clang Compiler
set(CMAKE_C_COMPILER "${PS4_SDK_DIR}/host_tools/bin/orbis-clang.exe")
set(CMAKE_CXX_COMPILER "${PS4_SDK_DIR}/host_tools/bin/orbis-clang++.exe")

set(CMAKE_GENERATOR_CC "${PS4_SDK_DIR}/host_tools/bin/orbis-clang.exe")

set(CMAKE_C_FLAGS "-DORBIS -DPS4")
set(CMAKE_CXX_FLAGS "-DORBIS -DPS4")

set(CMAKE_C_COMPILER_FORCED 1)
set(CMAKE_CXX_COMPILER_FORCED 1)

set(CMAKE_EXE_LINKER_FLAGS_RELEASE "--Map --strip-unused-data"  CACHE STRING "" FORCE)

set(CMAKE_DEBUG_POSTFIX d)
