@echo off
echo %0
setlocal EnableDelayedExpansion
set LAST_ERROR=0
set SCRIPT_DIR=%~dp0
if !SCRIPT_DIR:~-1!==\ set SCRIPT_DIR=!SCRIPT_DIR:~0,-1!
set WORKING_DIR=!CD!
if !WORKING_DIR:~-1!==\ set WORKING_DIR=!WORKING_DIR:~0,-1!

orbis-clang.exe --version

rmdir /s /q build
mkdir build
pushd build

set PATH_TO_CMAKE=..\vendor\cmake\bin\cmake.exe
set REL_PATH=..\cmake\toolchain
pushd %REL_PATH%
set TOOLCHAIN_DIR=!CD!
popd %REL_PATH%
set TOOLCHAIN_DIR=!TOOLCHAIN_DIR:\=/!
set PLAYERCORE_PS4_TOOLCHAIN=!TOOLCHAIN_DIR!/PS4.cmake

%PATH_TO_CMAKE% -DCMAKE_TOOLCHAIN_FILE=!PLAYERCORE_PS4_TOOLCHAIN! -G "Visual Studio 14 2015 Orbis" ..
if ERRORLEVEL 1 goto error 

:build_debug
%PATH_TO_CMAKE% --build .\ -- /v:m /m /t:clean,build /p:Platform=Orbis /p:Configuration=Debug
if ERRORLEVEL 1 goto error

:build_release
%PATH_TO_CMAKE% --build .\ -- /v:m /m /t:clean,build /p:Platform=Orbis /p:Configuration=Release
if ERRORLEVEL 1 goto error

:done_building
goto end

:error
set LAST_ERROR=1
goto end

:end
popd
echo %0 exiting with result=!LAST_ERROR!
exit /b !LAST_ERROR!
endlocal
