@echo off
echo %0
setlocal EnableDelayedExpansion
set LAST_ERROR=0
set SCRIPT_DIR=%~dp0
if !SCRIPT_DIR:~-1!==\ set SCRIPT_DIR=!SCRIPT_DIR:~0,-1!
set WORKING_DIR=!CD!
if !WORKING_DIR:~-1!==\ set WORKING_DIR=!WORKING_DIR:~0,-1!

rmdir /s /q build
mkdir build
pushd build

set REL_PATH=..\cmake\toolchain
pushd !REL_PATH!
set L_CMAKE_TOOLCHAIN_DIR=!CD!
popd

set L_CMAKE_TOOLCHAIN_DIR=!L_CMAKE_TOOLCHAIN_DIR:\=/!
set L_CMAKE_TOOLCHAIN_FILE=!L_CMAKE_TOOLCHAIN_DIR!/XboxOne.cmake

cmake.exe -DCMAKE_TOOLCHAIN_FILE=!L_CMAKE_TOOLCHAIN_FILE! -G "Visual Studio 15 Win64" ..
if ERRORLEVEL 1 goto error

:build_debug
cmake.exe --build .\ -- /m /t:clean,build /p:Configuration=Debug
if ERRORLEVEL 1 goto error

:build_release
cmake.exe --build .\ -- /m /t:clean,build /p:Configuration=Release
if ERRORLEVEL 1 goto error

:done_building
goto end

:error
set LAST_ERROR=1
goto end

:end
popd
echo %0 exiting with result=!LAST_ERROR!
exit /b !LAST_ERROR!
endlocal
