#include "native_jni.hpp"
#include <cstdlib>
#include <cstring>
#include <jni.h>

extern "C" {
jobject g_surface = NULL;
JNIEXPORT jint JNICALL JNI_OnLoad(JavaVM* vm, void* reserved)
{
    (void)reserved;
    twitch::AndroidPlatform::initialize(vm);
    return JNI_VERSION_1_6;
}

JNIEXPORT jlong Java_tv_twitch_player_android_example_ndk_NativeActivity_createPlayer(JNIEnv* env, jobject context,
    jobject surface)
{
    (void)context;
    if (g_surface) {
        env->DeleteGlobalRef(g_surface);
    }
    g_surface = env->NewGlobalRef(surface);
    auto platform = twitch::AndroidPlatform::create(env, context);
    NativePlayer* player = new NativePlayer(platform);
    player->getPlayer().setSurface(g_surface);
    return reinterpret_cast<jlong>(player);
}

void Java_tv_twitch_player_android_example_ndk_NativeActivity_startPlayer(JNIEnv* env, jobject context,
    jlong handle)
{
    (void)env;
    (void)context;
    const std::string url = "https://www.twitch.tv/monstercat";

    auto& player = reinterpret_cast<NativePlayer*>(handle)->getPlayer();
    player.load(url);
    player.play();
}

void Java_tv_twitch_player_android_example_ndk_NativeActivity_releasePlayer(JNIEnv* env, jobject context,
    jlong handle)
{
    (void)env;
    (void)context;
    delete reinterpret_cast<NativePlayer*>(handle);
}
};
