#pragma once
#include "playercore/platform/android/AndroidPlatform.hpp"
#include "playercore/Player.hpp"

class NativePlayer : public twitch::Player::Listener {
public:
    NativePlayer(std::shared_ptr<twitch::AndroidPlatform> platform)
    {
        m_player = twitch::Player::create(*this, platform);
    }
    twitch::Player& getPlayer() { return *m_player; }

    // Player::Listener overrides
    void onDurationChanged(twitch::MediaTime) override{};
    void onError(const twitch::Error&) override{};
    void onRecoverableError(const twitch::Error&) override{};
    void onMetadata(const std::string&, const std::vector<uint8_t>&) override{};
    void onQualityChanged(const twitch::Quality&) override{};
    void onRebuffering() override{};
    void onSeekCompleted(twitch::MediaTime) override{};
    void onSessionData(const std::map<std::string, std::string>&) override{}
    void onStateChanged(twitch::Player::State) override{};
    void onAnalyticsEvent(const std::string&, const std::string&) override{};
    void onPositionChanged(twitch::MediaTime) override{};

private:
    std::shared_ptr<twitch::Player> m_player;
};
