#import "ViewController+PiP.h"

@implementation ViewController (PiPDelegate)

- (void)setupPictureInPicture:(AVPlayerLayer*)layer
{
    if ([AVPictureInPictureController isPictureInPictureSupported]) {
        self.pictureInPictureController = [[AVPictureInPictureController alloc] initWithPlayerLayer:layer];
        self.pictureInPictureController.delegate = self;

        // Enable the pictureInPictureButton only if pictureInPicturePossible is true.
        self.pictureInPictureButton.enabled = YES; //self.pictureInPictureController.isPictureInPicturePossible;

    } else {
        self.pictureInPictureButton.enabled = NO;
    }
}

- (void)pictureInPictureControllerWillStartPictureInPicture:(AVPictureInPictureController*)PiPController
{
    (void)PiPController;
    NSLog(@"pictureInPictureControllerWillStartPictureInPicture");
}

- (void)pictureInPictureControllerDidStartPictureInPicture:(AVPictureInPictureController*)PiPController
{
    (void)PiPController;
    NSLog(@"pictureInPictureControllerDidStartPictureInPicture");
}

- (void)pictureInPictureController:(AVPictureInPictureController*)PiPController failedToStartPictureInPictureWithError:(NSError*)error
{
    (void)PiPController;
    NSLog(@"failedToStartPictureInPictureWithError");
}

- (void)pictureInPictureControllerWillStopPictureInPicture:(AVPictureInPictureController*)PiPController
{
    (void)PiPController;
    NSLog(@"pictureInPictureControllerWillStopPictureInPicture");
}

- (void)pictureInPictureControllerDidStopPictureInPicture:(AVPictureInPictureController*)PiPController
{
    (void)PiPController;
    NSLog(@"pictureInPictureControllerDidStopPictureInPicture");
}

- (BOOL)pictureInPictureControllerShouldAutomaticallyDismissAtPictureInPictureStart:(AVPictureInPictureController*)PiPController
{
    (void)PiPController;
    return YES;
}

- (void)pictureInPictureController:(AVPictureInPictureController*)PiPController restoreUserInterfaceForPictureInPictureStopWithCompletionHandler:(void (^)(BOOL restored))completionHandler
{
    (void)PiPController;
    NSLog(@"restoreUserInterfaceForPictureInPictureStopWithCompletionHandler");
}

/*
 Toggle picture in picture mode.
 If active, stop picture in picture and return to inline playback.
 If not active, initiate picture in picture.
 */
- (IBAction)togglePictureinPictureMode:(UIButton*)sender
{
    if (self.pictureInPictureController.pictureInPictureActive) {
        [self.pictureInPictureController stopPictureInPicture];
    } else {
        [self.pictureInPictureController startPictureInPicture];
    }
}

@end
