#import "ViewController+Picker.h"

@implementation ViewController (PickerDelegate)

- (NSInteger)numberOfComponentsInPickerView:(UIPickerView *)pickerView
{
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView numberOfRowsInComponent:(NSInteger)component
{
    return self.qualities.count;
}

- (NSString *)pickerView:(UIPickerView *)thePickerView
titleForRow:(NSInteger)row forComponent:(NSInteger)component
{
    return self.qualities[row];
}

- (void)pickerView:(UIPickerView *)thePickerView
didSelectRow:(NSInteger)row
inComponent:(NSInteger)component
{
    self.picker.hidden = YES;
    NSString* quality = [self.qualities objectAtIndex:row];
    if ([quality isEqualToString:@"Auto"]) {
        [self.player setAutoSwitchQuality:YES];
    } else {
        [self.player setQualityByName:quality];
    }
}

- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField
{
    self.picker.hidden = NO;
    self.picker.userInteractionEnabled = YES;
    return (textField != self.pickerText);
}

-(void)updateQualityControl
{
    self.pickerText.delegate = self;
    self.pickerText.hidden = NO;
    self.picker.delegate = self;
    self.picker.dataSource = self;

    NSArray *qualities = [self.player.qualities allObjects];
    self.qualities = [[NSMutableArray alloc] init];
    [self.qualities addObject:@"Auto"];
    for (id quality in qualities)
    {
        [self.qualities addObject:[(TTVQuality*)(quality) name]];
    }
}

-(void)updatePickerQuality:(NSString*)name
{
    if (self.player.autoSwitchQuality) {
        self.pickerText.text = [name stringByAppendingString:@"(Auto)"];
    } else {
        self.pickerText.text = name;
    }
}

-(void)initPickerView
{
    self.picker.hidden = YES;
    self.pickerText.hidden = YES;
}

@end
