
#import "TTVPlayer.h"
#import <AVKit/AVKit.h>
#import <UIKit/UIKit.h>
#import <AVFoundation/AVFoundation.h>
#import <MediaPlayer/MediaPlayer.h>

@class MPVolumeView;

#if TARGET_OS_IOS && !TARGET_OS_TV
@interface ViewController : UIViewController <UITextFieldDelegate, TTVPlayerDelegate, AVPictureInPictureControllerDelegate, UIPickerViewDelegate>

#pragma mark - UI Properties: PictureInPicture
@property (strong, nonatomic) AVPictureInPictureController* pictureInPictureController;
@property (strong, nonatomic) IBOutlet UIButton* pictureInPictureButton;

#pragma mark - UI Properties: Slider
@property (strong, nonatomic) IBOutlet UISlider* slider;

#pragma mark - UI Properties: Picker
@property (weak, nonatomic) IBOutlet UITextField *pickerText;
@property (weak, nonatomic) IBOutlet UIPickerView *picker;
@property (strong, nonatomic) NSMutableArray *qualities;

#pragma mark - UI Properties: Full Screen & Volume
@property (strong, nonatomic) IBOutlet MPVolumeView* volumeView;
#else
@interface ViewController : UIViewController <UITextFieldDelegate, TTVPlayerDelegate>
#endif

#pragma mark - UI Properties: Play & Load

@property (strong, nonatomic) IBOutlet UIButton* playPauseButton;
@property (strong, nonatomic) IBOutlet UITextField* urlTextField;
@property (strong, nonatomic) IBOutlet UIActivityIndicatorView* activityIndicator;
@property (strong, nonatomic) IBOutlet UILabel* statsLabel;

#pragma mark - UI Properties: Player View

@property (strong, nonatomic) IBOutlet UIView* playerView;

#pragma mark - UI Properties: Time Controls

@property (strong, nonatomic) IBOutlet UILabel* positionLabel;
@property (strong, nonatomic) IBOutlet UILabel* durationLabel;

- (IBAction)onPlayPauseButton:(id)sender;
- (IBAction)onSlider:(id)sender;

// UITextFieldDelegate
// called when 'return' key pressed. return NO to ignore.
- (BOOL)textFieldShouldReturn:(UITextField*)textField;

@property (nonatomic, readonly) TTVPlayer* player;

@end
