#pragma once

#include <string>
#include <vector>

namespace twitch {
class Options {
public:
    Options() = default;
    bool parse(int argc, const char* argv[]);

    const std::vector<std::string>& getUrls() const { return m_urls; }
    int getNumFramesToRun() const { return m_numFramesRun; }
    int getSeekTo() const { return m_seekTo; }
    bool getDefaultQuality() const { return m_defaultQuality; }
    bool isDumpSegments() const { return m_dumpSegments; }
    bool isUseFrameLogger() const { return m_useFrameLogger; }
    bool isAbsDisabled() const { return m_disableAbs; }

protected:
private:
    std::vector<std::string> m_urls;
    int m_numFramesRun = 0;
    int m_seekTo = 0;
    bool m_defaultQuality = false;
    bool m_dumpSegments = false;
    bool m_useFrameLogger = false;
    bool m_disableAbs = false;
};
}