#include <cstdio>
#include <cstring>
#include <iostream>

#include "platforms/posix/PosixPlatform.hpp"
#include "player/MediaPlayer.hpp"
#include "player/CompositeListener.hpp"
#include "debug/trace.hpp"

using namespace twitch;

int main(int argc, const char** argv)
{
    std::string output;
    std::string url = "http://twitch.tv/bufferbunny";

    if (1 < argc) {
        url = argv[1];
    }

    if (2 < argc) {
        output = argv[2];
    }

    CompositeListener emptyListener;
    MediaPlayer player(emptyListener, std::make_shared<PosixPlatform>(false, output));
    player.setAutoSwitchQuality(false);
    player.load(url);
    player.play();

    for (std::string line; std::getline(std::cin, line);) {
        // Quit on any inputline for now
        break;
    }

    player.pause();

    return EXIT_SUCCESS;
}
