﻿
#pragma once

#include <cstdint>
#include <memory>

namespace twitch {
class VideoFrame;
class VideoFrameBuffer;
}

class Surface {
public:
    virtual void onVideoFrameBuffer(const std::shared_ptr<twitch::VideoFrameBuffer>& frameBuffer) = 0;
    virtual void onFrameNeedsReleasing(const std::shared_ptr<twitch::VideoFrame>& videoFrame) = 0;
};

class MyDisplay {
public:
    struct RenderStruct {
        void* frameBuffer = nullptr;
        uint32_t width = 0;
        uint32_t height = 0;
        uint32_t pitch = 0;
        uint32_t cropLeft;
        uint32_t cropRight;
        uint32_t cropTop;
        uint32_t cropBottom;
    };

    virtual ~MyDisplay();
    virtual int initialize() = 0;
    virtual void finalize(void) = 0;
    static MyDisplay* create();

    virtual void update() = 0;
    virtual void render() = 0;

    virtual Surface* getSurface(uint32_t index) = 0;
    virtual void toggleSplitView() = 0;

protected:
private:
};
