#pragma once

#include <memory>
#include <mutex>
#include <condition_variable>
#include <sampleutil.h>

class MyDisplay;

namespace twitch {
class NativePlayer : public sce::SampleUtil::SampleSkeleton {
public:
    // SampleSkeleton overrides
    int initialize() override;
    int update() override;
    void render() override;
    int finalize() override;

    virtual int run();
    virtual void stop();

    MyDisplay* display() { return mp_display; }

protected:
    MyDisplay* mp_display;

    std::mutex m_mutex;
    std::condition_variable m_condition;
    enum class State {
        Running,
        Stopping,
        Stopped
    };
    State m_state = State::Running;
};
}
