﻿/*
 * SCE CONFIDENTIAL
 * PlayStation(R)4 Programmer Tool Runtime Library Release 03.508.201
 * Copyright (C) 2016 Sony Computer Entertainment Inc.
 * All Rights Reserved.
 */

#ifndef _SHADER_CONSTANT_H_
#define _SHADER_CONSTANT_H_

#ifdef __PSSL__
#define unistruct ConstantBuffer
#else
#define unistruct struct
#endif

#define ENABLE_10_10_10_2
#define PIXELS_PER_TEXEL_DST (3)
#define PITCH_ALIGNMENT (64)
#define ALIGN_NBYTES(__value__,__N__)  (~((__N__)-1) & ((__value__) + ((__N__)-1)))

unistruct VsConstants
{
    float tex_coord_left;
    float tex_coord_top;
    float tex_coord_right;
    float tex_coord_bottom;
    int vertical_split; // 0 = unused, 1 = left, 2 = right
};

unistruct PsConstants
{
    float bit_range_coeff;
    uint hdr_10_10_10_2;
    //#ifdef ENABLE_10_10_10_2
    uint disp_w;
    uint disp_h;
    uint frame_w;
    uint frame_h;
    uint ptex_w;
    uint ptex_h;
    //#endif
};

#endif
