#pragma once
#include "playercore/platform/ps4/PlayerCore.hpp"
#include "playercore/Player.hpp"

class StreamPlayer : public twitch::Player::Listener {
public:
    using OnVideoFrameBuffer = twitch::ps4::PlayerCore::OnVideoFrameBuffer;
    using OnFrameNeedsReleasing = twitch::ps4::PlayerCore::OnFrameNeedsReleasing;

    // Listener to notify when a stream has started after loading
    struct Listener {
        virtual void onStreamStarted() = 0;
    };

    struct Configuration {
        Configuration() {}

        // If enabled, each stream will set its initial quality to the default quality
        bool defaultInitialQuality = false;

        // The initial time to seek to when a stream is ready
        double initialSeekTime = 0.0;
    };

    StreamPlayer(Listener& listener, OnVideoFrameBuffer onVideoFrameBuffer, OnFrameNeedsReleasing onFrameNeedsReleasing, Configuration config = Configuration());

    const twitch::Player& getPlayer() const { return *m_player; }
    twitch::Player& getPlayer() { return *m_player; }

    // Player controls
    void load(const std::string& url);
    void pause();
    void play();
    void seekBackwards(twitch::MediaTime time);
    void seekForwards(twitch::MediaTime time);
    twitch::MediaTime getPosition() { return m_player->getPosition(); }
    void setNextQuality();
    void generatePlaySession();
    void keepPlaySession(bool keep);
    void setAuthToken(const std::string& token);

    // Player::Listener overrides
    void onDurationChanged(twitch::MediaTime) override;
    void onError(const twitch::Error&) override;
    void onMetadata(const std::string&, const std::vector<uint8_t>&) override {}
    void onQualityChanged(const twitch::Quality&) override;
    void onRebuffering() override {}
    void onRecoverableError(const twitch::Error&) override {}
    void onSeekCompleted(twitch::MediaTime time) override;
    void onSessionData(const std::map<std::string, std::string>&) override{}
    void onStateChanged(twitch::Player::State) override;
    void onAnalyticsEvent(const std::string&, const std::string&) override;
    void onPositionChanged(twitch::MediaTime) override {}

private:
    void setInitialQuality();

    Listener& m_listener;
    std::shared_ptr<twitch::Player> m_player;
    Configuration m_config;

    twitch::Player::State m_state = twitch::Player::State::Idle;
    bool m_streamStarted = false;
};
