#pragma once
#include "display.hpp"
#include <gnm/texture.h>
#include <gnmx/gfxcontext.h>
#include <mutex>

namespace twitch {
class VideoFrame;
class VideoFrameBuffer;
}

class View : public Surface {
public:
    // Used to pass as shader parameter
    enum class DisplayMode {
        Disabled = -1,
        FullScreen = 0,
        SplitLeft = 1,
        SplitRight = 2
    };

    void draw(sce::Gnmx::GfxContext* context);

    void onVideoFrameBuffer(const std::shared_ptr<twitch::VideoFrameBuffer>& frameBuffer) override;
    void onFrameNeedsReleasing(const std::shared_ptr<twitch::VideoFrame>& videoFrame) override;

    bool update();

    void setDisplayMode(DisplayMode mode) { m_mode = mode; }

private:
    void flush();

    DisplayMode m_mode;

    sce::Gnm::Texture m_lumaTexture;
    sce::Gnm::Texture m_chromaTexture;

    std::shared_ptr<twitch::VideoFrameBuffer> m_frameBuffer;
    std::mutex m_mutex;
    std::shared_ptr<twitch::VideoFrame> m_current;
};
