#!/bin/bash
# Create CA
# Add ca.pem to your keychain and trust it
# If you dont want to trust this one, You can generate a new CA for yourself by running
# openssl genrsa -out ca.key 4096
# openssl req -x509 -new -nodes -key ca.key -days 3650 -out ca.pem -subj '/C=US/ST=California/L=San Francisco/CN=Player-Core CA'
# Create cert. Shouldnt be necessary, for 10 years but shouldnt hurt eaither if you trusted the CA
openssl genrsa -out server.key 4096
openssl req -new -out server.csr -key server.key -subj '/C=US/ST=California/L=San Francisco/CN=*.twitch.tv'
openssl x509 -req -sha256 -extfile <(printf "subjectAltName=DNS:localhost.twitch.tv,DNS:localhost") -in server.csr -CA ca.pem -CAkey ca.key -CAcreateserial -out server.crt -days 3650
