// var ChromecastMediaPlayer = require('js/chromecast-mediaplayer')
// Prepare the mediaplayer and dom
var SCRIPT_ID = 'cvp-chromecast-library'
try {
    console['origLog'] = console.log;
    console.log = function(msg) {
        appendMessage('log-' + msg);
        console['origLog'](msg);
    };
    console['origError'] = console.error;
    console.log = function(msg) {
        appendMessage('error-' + msg);
        console['origError'](msg);
    };
    console['origWarn'] = console.warn;
    console.log = function(msg) {
        appendMessage('warn- ' + msg);
        console['origWarn'](msg);
    };

    var textArea = document.getElementById('debugmessage');
    textArea.addEventListener('change', function() {
        textArea.scrollTop = textArea.scrollHeight;
    });

    // Prepare the mediamanager and attach the player
    if (!cast) {
        appendMessage('no cast available');
    }

    //Prepare the receiver
    var castReceiverManager = cast.receiver.CastReceiverManager.getInstance();
    var mediaManager = new cast.receiver.MediaManager(document.createElement('video'));
    var scriptPromise;
    mediaManager['origOnLoad'] = mediaManager.onLoad;
    mediaManager.onLoad = function (event) {
        scriptPromise.then(function(mediaPlayer) {
            mediaManager.setMediaElement(mediaPlayer);
            var data = event.data;
            appendMessage('on Load event fired ' + JSON.stringify(data));
            appendMessage('loading url  ' + JSON.stringify(data.media.contentId));
            appendMessage('autoplay is set to ' + JSON.stringify(data.autoplay));

            mediaPlayer.load(data.media.contentId, data.autoplay);
            mediaManager['origOnLoad'](event);
        });
    };

    mediaManager['origOnError'] = mediaManager.onError;
    mediaManager.onError = function (event) {
        appendMessage('on error event fired ' + JSON.stringify(event));
        mediaManager['origOnError'](event);
    };

    var messageBus = castReceiverManager.getCastMessageBus('urn:x-cast:tv.twitch.cvpweb');

    messageBus.addEventListener('message', function(event) {
        console.warn('received event', event);

        var dataObj = event.data;
        if (typeof dataObj === 'string') {
            dataObj = JSON.parse(dataObj);
        }

        if (dataObj.url) {
            scriptPromise = loadScript(dataObj.url).then(function() {
                var mediaPlayer = new TwitchChromecastMediaPlayer('', 'debug');

                var videoElement = mediaPlayer.getHTMLVideoElement();

                videoElement.addEventListener('loadedmetadata', function() {
                    appendMessage('video element fired loadedmetadata');
                });

                videoElement.addEventListener('playing', function() {
                    appendMessage('video element fired playing event');
                });

                var videoContainer = document.getElementById('video-container');
                videoContainer.appendChild(videoElement);
                return mediaPlayer;
            });
        } else if (dataObj.toggle) {
            var messageArea = document.getElementById('message-area');
            var videoArea = document.getElementById('video-container');
            if (messageArea.style.zIndex > videoArea.style.zIndex) {
                videoArea.style.zIndex = 2;
                messageArea.style.zIndex = 1;
            } else {
                videoArea.style.zIndex = 1;
                messageArea.style.zIndex = 2;
            }
        }
    });

    castReceiverManager.onSenderDisconnected = function(event) {
        appendMessage('sender disconnected');
        if(castReceiverManager.getSenders().length === 0
           || event.reason == cast.receiver.system.DisconnectReason.REQUESTED_BY_SENDER) {
          appendMessage('closing window');
          window.close();
        }
    };

    castReceiverManager.onSenderConnected = function(event) {
        appendMessage('Sender connected, senderId:' + JSON.stringify(event));
    };

    castReceiverManager.onReady = function(event) {
        appendMessage('Ready event, applicationData:' + JSON.stringify(event.applicationData));
    };

    var appConfig = new cast.receiver.CastReceiverManager.Config();
    appConfig.statusText = 'CVP Chromecast receiver ready to cast';
    appConfig.maxInactivity = 10000;
    appendMessage('Starting receiver manager');
    castReceiverManager.start(appConfig);
} catch (e) {
    debugger;
    console.error(e);
    appendMessage('exception ' + JSON.stringify(e));
}

function appendMessage(message) {
  var dw = document.getElementById('debugmessage');
  dw.innerHTML = '\n' + JSON.stringify(message) + dw.innerHTML;
}

function loadScript(url) {
    return new Promise(function(resolve, reject) {
        var scriptTag = document.createElement('script');
        scriptTag.id = SCRIPT_ID;
        scriptTag.onload = resolve;
        scriptTag.onError = reject;
        scriptTag.src = url;
        document.head.appendChild(scriptTag);
    });
}
