module.exports = DownloadHelper;

var MAX_SIZE = 50 * 1024 * 1024;
function DownloadHelper() {
    this._videoBufferQueue = [];
    this._audioBufferQueue = [];
    this._currentSize = 0;
}

DownloadHelper.prototype.addVideoBuffer = function (buf) {
    if (this._currentSize > MAX_SIZE) {
        return;
    }
    this._videoBufferQueue.push(buf);
    this._currentSize += buf.byteLength;
};

DownloadHelper.prototype.addAudioBuffer = function (buf) {
    if (this._currentSize > MAX_SIZE) {
        return;
    }
    this._audioBufferQueue.push(buf);
}

DownloadHelper.prototype.download = function () {
    if (this._currentSize > 0) {
        this._helper(this._videoBufferQueue, 'video');
        this._helper(this._audioBufferQueue, 'audio');
        return true;
    }
    return false;
};

DownloadHelper.prototype._helper = function (buffer, name) {
    var blob = new Blob(buffer, {
        type: 'octet/stream'
    });
    var blobURL = URL.createObjectURL(blob);
    var dummyAnchor = document.createElement('a');
    dummyAnchor.download = name + '.mp4';
    dummyAnchor.innerHTML = 'dummy';
    dummyAnchor.href = blobURL;
    dummyAnchor.onclick = function(e) {
        document.body.removeChild(e.target);
    };
    dummyAnchor.style.display = 'none';
    document.body.appendChild(dummyAnchor);
    dummyAnchor.click();
}
