// videojs and videojs-hls-tech expected
if (typeof registerTwitchTechForVideoJs === 'function') {
    window.HELP_IMPROVE_VIDEOJS = false;
    var params = (function () {
        var params = {};
        var query = location.search.substring(1);
        var vars = query.split('&');
        for (var i = 0; i < vars.length; i++) {
            var pair = vars[i].split('=');
            params[decodeURIComponent(pair[0])] = decodeURIComponent(pair[1]);
        }
        return params;
    }());
    registerTwitchTechForVideoJs(videojs, {
        logLevel: params['logLevel'],
    });
    var autoplay = ('autoplay' in params) ? (params['autoplay'] === 'true') : false;

    var player = videojs('twitch-videojs', {
        techOrder: ["TwitchWhiteLabel"],
        languages: {
            es: {
                Quality: 'calidad'
            }
        },
        language: params['lang'],
        muted: params['muted'] === 'true',
        autoplay: autoplay
    }, function() {
        console.warn('Player is ready to use')
    });

    window.player = player;

    player.enableTwitchPlugins(); //enables twitch's quality plugin

    var TwitchTech = player.getTwitchTech();

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.QUALITY_CHANGED, function (q) {
        console.warn('PlayerEvent.QUALITY_CHANGED event', q);
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.AUTO_SWITCH_QUALITY_CHANGED, function (q) {
        console.warn('PlayerEvent.AUTO_SWITCH_QUALITY_CHANGED event', q);
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.TRACKING, function (obj) {
        console.warn('PlayerEvent.TRACKING event', obj.name, obj.properties);
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.ERROR, function (type, source) {
        console.warn('PlayerEvent.ERROR event', type, source);
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.AUDIO_BLOCKED, function () {
        console.warn('PlayerEvent.AUDIO_BLOCKED event');
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.PLAYBACK_BLOCKED, function () {
        console.warn('PlayerEvent.PLAYBACK_BLOCKED event');
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerEvent.REBUFFERING, function () {
        console.warn('PlayerEvent.REBUFFERING event');
    });

    player.addTwitchTechEventListener(TwitchTech.MetadataEvent.SPLICE_OUT, function () {
        console.warn('MetadataEvent.SPLICE_OUT event');
    });

    player.addTwitchTechEventListener(TwitchTech.MetadataEvent.SPLICE_IN, function () {
        console.warn('MetadataEvent.SPLICE_IN event');
    });

    player.addTwitchTechEventListener(TwitchTech.MetadataEvent.CAPTION, function (caption) {
        console.warn('MetadataEvent.CAPTION event', caption);
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerState.PLAYING, function () {
        console.warn('PlayerState.PLAYING event');
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerState.IDLE, function () {
        console.warn('PlayerState.IDLE event');
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerState.READY, function () {
        console.warn('PlayerState.READY event');
    });

    player.addTwitchTechEventListener(TwitchTech.PlayerState.BUFFERING, function () {
        console.warn('PlayerState.BUFFERING event');
    });

    if (params.channel) {
        player.src('https://twitch.tv/' + params.channel);
    } else if (params.video) {
        player.src('https://twitch.tv/video/v/' + params.video);
    } else if (params.customerId && params.contentId) {
        player.src('https://usher.ttvnw.net/api/lvs/hls/lvs.' + params.customerId + '.' + params.contentId + '.m3u8?allow_source=true&player_backend=mediaplayer')
    }

    var urlInput = document.getElementById('videourl');
    urlInput.addEventListener('change', function (e) {
        player.src(e.target.value);
    });

    player.getBufferDuration();
    player.getDisplayHeight();
    player.getDisplayWidth();
    player.getDroppedFrames();
    player.getLiveLatency();
    player.getVersion();
    player.getVideoBitRate();
    player.getVideoFrameRate();
    player.getVideoHeight();
    player.getVideoWidth();
    player.isLiveLowLatency();
    player.setAutoViewportSizeEnabled(true);
} else {
    console.error('registerTwitchTechForVideoJs function is not available');
}
