package tv.twitch.player.android.webviewtest;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.TextView;

import tv.twitch.player.android.webviewtest.R;


public class PlayerActivity extends Activity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            WebView.setWebContentsDebuggingEnabled(true);
        }
        setContentView(R.layout.activity_player);
        WebView view = (WebView) findViewById(R.id.webview);

        view.getSettings().setJavaScriptEnabled(true);
        view.getSettings().setDomStorageEnabled(true);

        if (Build.VERSION.SDK_INT > Build.VERSION_CODES.JELLY_BEAN) {
            view.getSettings().setMediaPlaybackRequiresUserGesture(false);
        }

        view.setLayerType(View.LAYER_TYPE_HARDWARE, null);

        WebViewClient client = new WebViewClient();
        view.setWebViewClient(client);
        view.setWebChromeClient(new WebChromeClient() {

            @Override
            public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
                String tag = "Twitch";
                switch (consoleMessage.messageLevel()) {
                    case DEBUG:
                        Log.d(tag, consoleMessage.message());
                        break;
                    case ERROR:
                        Log.e(tag, consoleMessage.message());
                        break;
                    case LOG:
                        Log.i(tag, consoleMessage.message());
                        break;
                    case TIP:
                        break;
                    case WARNING:
                        Log.w(tag, consoleMessage.message());
                        break;
                }
                return true;
            }
        });

        final EditText addressBar = (EditText) findViewById(R.id.address);

        addressBar.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            @Override
            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == EditorInfo.IME_ACTION_GO) {
                    WebView view = (WebView) findViewById(R.id.webview);
                    CharSequence seq = v.getText();
                    view.loadUrl(seq.toString());
                    InputMethodManager imm = (InputMethodManager)getSystemService(Context.INPUT_METHOD_SERVICE);
                    imm.hideSoftInputFromWindow(addressBar.getWindowToken(), InputMethodManager.RESULT_UNCHANGED_SHOWN);
                    return true;
                }
                return false;
            }
        });
    }
}
