#include "pch.h"
#include "App.h"

using namespace nativeplayer;
using namespace Windows::Foundation;

static App* app;

static BOOL InitInstance(HINSTANCE, int);
static LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
static INT_PTR CALLBACK About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY wWinMain(_In_ HINSTANCE hInstance, _In_opt_ HINSTANCE /*hPrevInstance*/, _In_ LPWSTR /*lpCmdLine*/, _In_ int nCmdShow)
{
    // Perform application initialization.
    App app_;
    app = &app_;
    app_.Initialize();
    if (!InitInstance(hInstance, nCmdShow)) {
        return 1;
    }

    app_.Run();

    return 0;
}

App::App()
{
}

void App::Initialize()
{
    // At this point we have access to the device.
    // We can create the device-dependent resources.
    m_deviceResources = std::make_shared<DX::DeviceResources>();

    // TODO: pass-in the actual CommandLine
    m_application.parseCommandLine(0, NULL);
    m_application.initialize(m_deviceResources->GetDevice());
}

void App::SetWindow(HWND window)
{
    m_deviceResources->SetWindow(window);
}

// Initialize scene resources.
void App::Load()
{
    m_main = std::make_unique<nativeplayerMain>(m_deviceResources, m_application);
}

// This method is called after the window becomes active.
void App::Run()
{
    HACCEL const hAccelTable = LoadAccelerators(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDC_WIN32PLAYER));
    MSG msg;
    for(bool isIdle; isIdle = !PeekMessage(&msg, nullptr, 0u, 0u, PM_REMOVE), msg.message != WM_QUIT;) {
        if (isIdle) {
            m_application.update();
            m_main->Update();

            if (m_main->Render()) {
                m_deviceResources->Present();
            }
        } else {
            if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) {
                TranslateMessage(&msg);
                DispatchMessage(&msg);
            }
        }
    }
}

// Window event handlers.

void App::OnWindowSizeChanged(HWND /*sender*/, UINT /*state*/, int cx, int cy)
{
    m_deviceResources->SetLogicalSize(Size{ static_cast<float>(cx), static_cast<float>(cy) });
    m_main->CreateWindowSizeDependentResources();
}

void App::OnPointerPressed(HWND /*sender*/, BOOL /*fDoubleClick*/, int x, int y, UINT /*keyFlags*/)
{
    // When the pointer is pressed begin tracking the pointer movement.
    m_main->StartTracking();
    m_main->TrackingUpdate(Point());
    m_pointerStartPosition = Point{ x, y };

    m_main->OnPointerPressed(m_pointerStartPosition);
}

void App::OnPointerMoved(HWND /*sender*/, int x, int y, UINT /*keyFlags*/)
{
    // Update the pointer tracking code.
    if (m_main->IsTracking()) {
        Point diff;
        diff.X = x - m_pointerStartPosition.X;
        diff.Y = y - m_pointerStartPosition.Y;
        m_main->TrackingUpdate(diff);
    }
}

void App::OnPointerReleased(HWND /*sender*/, int x, int y, UINT /*keyFlags*/)
{
    // Stop tracking pointer movement when the pointer is released.
    m_main->StopTracking();

    m_main->OnPointerReleased(Point{ x, y });
}

void App::OnKeyUp(HWND /*sender*/, UINT vk, BOOL /*fDown*/, int /*cRepeat*/, UINT /*flags*/)
{
    switch(vk)
    {
        case 'A':
            m_application.play();
            break;
        case 'X':
            m_application.pause();
            break;
        case 'Y':
            m_application.selectPreviousVideo();
            break;
        case 'B':
            m_application.selectNextVideo();
            break;
        case VK_UP:
            m_application.seekBackward30Seconds();
            break;
        case VK_DOWN:
            m_application.seekForward30Seconds();
            break;
        case VK_LEFT:
            m_application.seekBackward5Seconds();
            break;
        case VK_RIGHT:
            m_application.seekForward5Seconds();
            break;
        case '[':
            m_application.setPreviousQuality();
            break;
        case ']':
            m_application.setNextQuality();
            break;
    }
}

static BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    // Register the window class.
    WNDCLASSEXW wcex;
    wcex.cbSize = sizeof(WNDCLASSEX);
    wcex.style = CS_HREDRAW | CS_VREDRAW;
    wcex.lpfnWndProc = WndProc;
    wcex.cbClsExtra = 0;
    wcex.cbWndExtra = 0;
    wcex.hInstance = hInstance;
    wcex.hIcon = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_WIN32PLAYER));
    wcex.hCursor = LoadCursor(nullptr, IDC_ARROW);
    wcex.hbrBackground = reinterpret_cast<HBRUSH>(COLOR_WINDOW + 1);
    wcex.lpszMenuName = MAKEINTRESOURCEW(IDC_WIN32PLAYER);
    wcex.lpszClassName = L"NativePlayer";
    wcex.hIconSm = wcex.hIcon;
    RegisterClassExW(&wcex);

    LPCWSTR szTitle = L"NativePlayer"; // the title bar text
    HWND const hWnd = CreateWindowW(wcex.lpszClassName, szTitle, WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, nullptr, hInstance, nullptr);

    if (!hWnd) {
        return FALSE;
    }

    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);

    return TRUE;
}

static bool OnCreate(HWND hwnd, LPCREATESTRUCT /*lpCreateStruct*/)
{
    app->SetWindow(hwnd);
    app->Load();
    return true;
}

static void OnCommand(HWND hwnd, int id, HWND /*hwndCtl*/, UINT /*codeNotify*/)
{
    // Parse the menu selections.
    switch(id) {
    case IDM_ABOUT:
        DialogBox(GetModuleHandle(nullptr), MAKEINTRESOURCE(IDD_ABOUTBOX), hwnd, About);
        break;
    case IDM_EXIT:
        DestroyWindow(hwnd);
        break;
    }
}

static LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch(message) {
        HANDLE_MSG(hWnd, WM_CREATE, OnCreate);
        HANDLE_MSG(hWnd, WM_COMMAND, OnCommand);
        HANDLE_MSG(hWnd, WM_KEYUP, app->OnKeyUp);
        HANDLE_MSG(hWnd, WM_LBUTTONDOWN, app->OnPointerPressed);
        HANDLE_MSG(hWnd, WM_LBUTTONUP, app->OnPointerReleased);
        HANDLE_MSG(hWnd, WM_MOUSEMOVE, app->OnPointerMoved);
        HANDLE_MSG(hWnd, WM_SIZE, app->OnWindowSizeChanged);
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    default:
        return DefWindowProc(hWnd, message, wParam, lParam);
    }
    return 0;
}

// message handler for about box
static INT_PTR CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM /*lParam*/)
{
    switch(message) {
    case WM_INITDIALOG:
        return TRUE;
    case WM_COMMAND:
        if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) {
            EndDialog(hDlg, LOWORD(wParam));
            return TRUE;
        }
        break;
    }
    return FALSE;
}
