// #define CUBE_MODE_ENABLED

// A constant buffer that stores the three basic column-major matrices for composing geometry.
cbuffer ModelViewProjectionConstantBuffer : register(b0)
{
    matrix model;
    matrix view;
    matrix projection;
};

// Per-vertex data used as input to the vertex shader.
struct VertexShaderInput
{
    float3 pos : POSITION;
    float2 tex : TEXCOORD0;
};

// Per-pixel color data passed through the pixel shader.
struct PixelShaderInput
{
    float4 pos : SV_POSITION;
    float2 tex : TEXCOORD0;
};

// Simple shader to do vertex processing on the GPU.
PixelShaderInput main(VertexShaderInput input)
{
    PixelShaderInput output;

#ifdef CUBE_MODE_ENABLED
    float4 pos = float4(input.pos, 1.0f);

    // Transform the vertex position into projected space.
    pos = mul(pos, model);
    pos = mul(pos, view);
    pos = mul(pos, projection);
    output.pos = pos;
#else
    float4 pos = float4(1.0f - input.tex.x, input.tex.y, 0.0f, 1.0f);
    pos.xy = 1.0f - (pos.xy * 2.0f);
    output.pos = pos;
#endif

    // Store the texture coordinates for the pixel shader.
    output.tex = input.tex;

    return output;
}
