
#include "pch.h"
#include "TextureMapper.hpp"
#include "TextureAndSRVNV12.hpp"
#include "../Common/DirectXHelper.h"
#include <assert.h>

TextureMapper::TextureMapper(std::shared_ptr<DX::DeviceResources> deviceResources, int defaultWidth, int defaultHeight)
    : m_deviceResources(deviceResources)
{
    // set default texture
    SetActive(defaultWidth, defaultHeight);
}

void TextureMapper::Reset()
{
    TextureMap::iterator it = m_textures.begin();
    for (; it != m_textures.end(); ++it)
    {
        (*it).second->Reset();
    }
}

void TextureMapper::Apply()
{
    auto context = m_deviceResources->GetD3DDeviceContext();

    ID3D11SamplerState *samplerState[] = { Get()->getSamplerState().Get() };
    context->PSSetSamplers(0, 1, samplerState);

    ID3D11ShaderResourceView *srv[] = { Get()->getSRV(0).Get(), Get()->getSRV(1).Get() };
    context->PSSetShaderResources(0, 2, srv);
}

void TextureMapper::SetActive(int width, int height)
{
    m_activeTexture = WidthHeight(width, height);
    Create(width, height);
}

void TextureMapper::Create(int width, int height)
{
    assert(width > 0 && height > 0);

    auto wh = WidthHeight(width, height);
    TextureMap::iterator it = m_textures.find(wh);
    if (it != m_textures.end()) // already exist, ignore request
        return;

    m_textures[wh] = std::make_shared<TextureAndSRVNV12>(m_deviceResources, width, height);
}

std::shared_ptr<TextureAndSRVNV12> TextureMapper::Get() const
{
    TextureMap::const_iterator it = m_textures.find(m_activeTexture);
    assert(it != m_textures.end());
    if (it == m_textures.end())
        return nullptr;

    return (*it).second;
}
